/*
 * Alert subsystem
 */

/*
 * Variables for managing alerts
 */
struct fms_alert_vars {
  struct fms_alert *alerts_anchor;	/* current alerts */

  uint32_t next_alert_id;		/* next alert ID to assign */
};


/*
 * Our structure for managing alerts
 */
struct fms_alert {
  struct lf_alert alert;	/* the alert info itself */

  struct fms_alert *main_next;	/* next for primary chain */
  struct fms_alert *main_prev;	/* previous for primary chain */

  struct fms_alert *subj_next;	/* next for chain of alert subject */
  struct fms_alert *subj_prev;	/* previous for chain of alert subject */
};


/*
 * Some inline helper functions
 */
static inline void
fms_init_alert_anchor(
  struct fms_alert *anchor)
{
  anchor->main_next = anchor;
  anchor->main_prev = anchor;
  anchor->subj_next = anchor;
  anchor->subj_prev = anchor;
}

static inline void
fms_subj_link_alert(
  struct fms_alert *anchor,
  struct fms_alert *ap)
{

  ap->subj_next = anchor->subj_next;
  ap->subj_prev = anchor;

  anchor->subj_next->subj_prev = ap;
  anchor->subj_next = ap;
}

static inline void
fms_main_link_alert(
  struct fms_alert *anchor,
  struct fms_alert *ap)
{

  ap->main_next = anchor->main_next;
  ap->main_prev = anchor;

  anchor->main_next->main_prev = ap;
  anchor->main_next = ap;
}

static inline void
fms_subj_unlink_alert(
  struct fms_alert *ap)
{
  ap->subj_prev->subj_next = ap->subj_next;
  ap->subj_next->subj_prev = ap->subj_prev;
}

static inline void
fms_main_unlink_alert(
  struct fms_alert *ap)
{
  ap->main_prev->main_next = ap->main_next;
  ap->main_next->main_prev = ap->main_prev;
}

/*
 * prototypes
 */
struct fms_alert *fms_allocate_alert(enum lf_alert_type type);
void fms_register_alert(struct fms_alert *ap);
void fms_cancel_alert(struct fms_alert *ap);
int fms_ack_alert(uint32_t id);
void fms_relic_alert(struct fms_alert *ap);
struct fms_alert *fms_find_alert(uint32_t id);
void fms_alert_relic_matches_in_subj_list(struct fms_alert *anchor,
					  lf_alert_type_t *types, int nt);
void fms_cancel_subject_alerts(struct fms_alert *anchor);


